<?php
/*
 * Template Name: Manga Homepage Template
 * Description: Custom template for the manga homepage
 */

get_header(); ?>

<div class="sy-body">
    <div class="container">
                <div id="primary" class="content-area sy-content-area">
                <main id="main" class="site-main">
                <div class="content">
                    <div id="manga-info">
                        <div id="manga-info-left">
                            <img class="manga-thumb" loading="eager" fetchpriority="high"
                                src="<?php echo esc_url(get_post_meta(get_the_ID(), 'cover_image', true)); ?>"
                                alt="<?php echo esc_html(get_post_meta(get_the_ID(), 'manga_title', true)); ?> Cover Image">
                                
                            <div id="rating-box">
                                <?php echo get_star_rating_html(esc_html(get_post_meta(get_the_ID(), 'rating', true))); ?>
                            </div>

                            <div class="extra-manga-info extra-manga-info-left">
                                <p>Type: <span><?php echo esc_html(get_post_meta(get_the_ID(), 'type', true)); ?></span>
                                </p>
                                <p>Status:
                                    <span
                                        class="text-uppercase"><?php echo esc_html(get_post_meta(get_the_ID(), 'status', true)); ?></span>
                                </p>
                                <p>Author(s):
                                    <span><?php echo esc_html(get_post_meta(get_the_ID(), 'authors', true)); ?></span>
                                </p>
                                <p>Artist(s):
                                    <span><?php echo esc_html(get_post_meta(get_the_ID(), 'artists', true)); ?></span>
                                </p>
                                <p>Released:
                                    <span><?php echo esc_html(get_post_meta(get_the_ID(), 'release_year', true)); ?></span>
                                </p>


                            </div>

                            <!-- Support Button -->
                            <div class="my-2 mx-auto d-flex justify-content-center">
                                <style>img.kofiimg{display: initial!important;vertical-align:middle;height:13px!important;width:20px!important;padding-top:0!important;padding-bottom:0!important;border:none;margin-top:0;margin-right:5px!important;margin-left:0!important;margin-bottom:3px!important;content:url('https://storage.ko-fi.com/cdn/cup-border.png')}.kofiimg:after{vertical-align:middle;height:25px;padding-top:0;padding-bottom:0;border:none;margin-top:0;margin-right:6px;margin-left:0;margin-bottom:4px!important;content:url('https://storage.ko-fi.com/cdn/whitelogo.svg')}.btn-container{display:inline-block!important;white-space:nowrap;min-width:160px}span.kofitext{color:#fff !important;letter-spacing: -0.15px!important;text-wrap:none;vertical-align:middle;line-height:33px !important;padding:0;text-align:center;text-decoration:none!important; text-shadow: 0 1px 1px rgba(34, 34, 34, 0.05);}.kofitext a{color:#fff !important;text-decoration:none:important;}.kofitext a:hover{color:#fff !important;text-decoration:none}a.kofi-button{box-shadow: 1px 1px 0px rgba(0, 0, 0, 0.2);line-height:36px!important;min-width:150px;display:inline-block!important;background-color:#29abe0;padding:2px 12px !important;text-align:center !important;border-radius:7px;color:#fff;cursor:pointer;overflow-wrap:break-word;vertical-align:middle;border:0 none #fff !important;font-family:'Quicksand',Helvetica,Century Gothic,sans-serif !important;text-decoration:none;text-shadow:none;font-weight:700!important;font-size:14px !important}a.kofi-button:visited{color:#fff !important;text-decoration:none !important}a.kofi-button:hover{opacity:.85;color:#f5f5f5 !important;text-decoration:none !important}a.kofi-button:active{color:#f5f5f5 !important;text-decoration:none !important}.kofitext img.kofiimg {height:15px!important;width:22px!important;display: initial;animation: kofi-wiggle 3s infinite;}@keyframes kofi-wiggle{0%{transform:rotate(0) scale(1)}60%{transform:rotate(0) scale(1)}75%{transform:rotate(0) scale(1.12)}80%{transform:rotate(0) scale(1.1)}84%{transform:rotate(-10deg) scale(1.1)}88%{transform:rotate(10deg) scale(1.1)}92%{transform:rotate(-10deg) scale(1.1)}96%{transform:rotate(10deg) scale(1.1)}100%{transform:rotate(0) scale(1)}}</style>
                                    <a title="Support me on ko-fi.com" class="kofi-button" style="background-color:#0074b3;" href="https://ko-fi.com/N4N6G1S5B" target="_blank"> <span class="kofitext"><img src="https://storage.ko-fi.com/cdn/cup-border.png" alt="Ko-fi donations" class="kofiimg">Support US</span></a>

                    
                            </div>
                        </div>
                        <div id="manga-info-right">
                            <div class="info-desc">
                                <h1><?php the_title(); ?></h1>
                                <h2>
                                    <?php echo esc_html(get_post_meta(get_the_ID(), 'alternative', true)); ?>
                                </h2>

                                <?php
                                    // Retrieve genre as string
                                    $genres_string = get_post_meta(get_the_ID(), 'genre', true);

                                    // Ensure the string is not empty and contains valid data
                                    if (!empty($genres_string)) {
                                        // Convert string to array by exploding, and trim whitespace from each genre
                                        $genres_array = array_map('trim', explode(',', $genres_string));

                                        // Output the list of genres
                                        if (!empty($genres_array)) {
                                            echo '<div class="genre-list">';
                                            foreach ($genres_array as $genre) {
                                                // Ensure the genre is not empty after trimming
                                                if (!empty($genre)) {
                                                    echo '<span class="genre-list-item">' . esc_html($genre) . '</span>';
                                                }
                                            }
                                            echo '</div>';
                                        }
                                    }
                                    ?>



                                
                                    <p>
                                    <span class="desc">
    <?php echo wp_kses_post(nl2br(get_post_meta(get_the_ID(), 'description', true))); ?>
                                    </span>
                                </p>

                            
                            </div>

                            <div class="extra-manga-info extra-manga-info-right">
                                
                                <p>Type: <span><?php echo esc_html(get_post_meta(get_the_ID(), 'type', true)); ?></span>
                                </p>
                                <p>Status:
                                    <span
                                        class="text-uppercase"><?php echo esc_html(get_post_meta(get_the_ID(), 'status', true)); ?></span>
                                </p>
                                <p>Author(s):
                                    <span><?php echo esc_html(get_post_meta(get_the_ID(), 'authors', true)); ?></span>
                                </p>
                                <p>Artist(s):
                                    <span><?php echo esc_html(get_post_meta(get_the_ID(), 'artists', true)); ?></span>
                                </p>
                                <p>Released:
                                    <span><?php echo esc_html(get_post_meta(get_the_ID(), 'release_year', true)); ?></span>
                                </p>
                            
                            </div>
                            
                            <div id="chapter-list">
                                <div class="d-flex flex-row justify-content-between">
                                    <h3 class="chapter-list-title"><?php echo esc_html(get_post_meta(get_the_ID(), 'manga_title', true)); ?> Chapters</h3>
                                    <button aria-label="reverse chapter's list order" id="switch-list-order">
                                        <i class="icon-sort"></i>
                                    </button>
                                </div>
                                <hr>
                                <div class="chapter-start-end">
                                    <?php
                                    // Query to get the first comic post
                                    $args_first = array(
                                        'post_type' => 'comic',
                                        'orderby' => 'menu_order',
                                        'posts_per_page' => 1,
                                        'order' => 'ASC',
                                    );
                                    $first_comic = new WP_Query($args_first);

                                    // Query to get the last comic post
                                    $args_last = array(
                                        'post_type' => 'comic',
                                        'orderby' => 'menu_order',
                                        'posts_per_page' => 1,
                                        'order' => 'DESC',
                                    );
                                    $last_comic = new WP_Query($args_last);

                                    // Check if there are any comic posts
                                    $count_comics = wp_count_posts('comic')->publish;

                                    // Output menu items based on the number of comic posts
                                    if ($count_comics > 0) {
                                        // Display the first comic post
                                        if ($first_comic->have_posts()):
                                            $first_comic->the_post();
                                            // Get the full title
                                            $full_title = get_the_title();
                                            // Extract "Chapter" or "chapter" and anything after it
                                            $short_title = extract_chapter_title($full_title);
                                            ?>
                                            <a href="<?php the_permalink(); ?>" aria-label="<?php the_title()?>">
                                                <span>First Chapter</span>
                                                <br>
                                                <?php echo esc_html($short_title); ?>
                                            </a>
                                            <?php
                                            wp_reset_postdata();
                                        endif;

                                        // Display the last comic post, only if there is more than one comic post
                                        if ($count_comics > 1 && $last_comic->have_posts()):
                                            $last_comic->the_post();
                                            // Get the full title
                                            $full_title = get_the_title();
                                            // Extract "Chapter" or "chapter" and anything after it
                                            $short_title = extract_chapter_title($full_title);
                                            ?>
                                            <a href="<?php the_permalink(); ?>" aria-label="<?php the_title()?>">
                                                <span>New Chapter</span>
                                                <br>
                                                <?php echo esc_html($short_title); ?>
                                            </a>
                                            <?php
                                            wp_reset_postdata();
                                        endif;
                                    }
                                    ?>
                                </div>

                                <input class="form-control mb-3" aria-label="search for chapter number" placeholder="search chapter number: example 23"
                                    Type="text" id="search-chapter-list">
                                <div class="chapter-list-holder d-flex flex-column" id="chapters-list-holder">
                                    <?php
                                    // Arguments for WP_Query
                                    $args = array(
                                        'post_type' => 'comic',
                                        'orderby' => 'menu_order',
                                        'order' => 'DESC',
                                        'posts_per_page' => -1,
                                    );

                                    // Custom query
                                    $custom_query = new WP_Query($args);

                                    // Check if there are any posts
                                    if ($custom_query->have_posts()):

                                        // Loop through the posts
                                        while ($custom_query->have_posts()):
                                            $custom_query->the_post();
                                            ?>
                                        
                                            <a href="<?php the_permalink(); ?>" aria-label="<?php echo esc_attr(get_the_title()); ?>" class="d-block chapter-list-item">
                                                <span class="chapter-name"><?php echo esc_html(extract_chapter_title(get_the_title())); ?></span>
                                                <span class="chapter-date"><?php echo esc_html(get_post_time('F j, Y')); ?></span>
                                            </a>
                                        
                                            <?php
                                        endwhile;

                                        // Restore original Post Data
                                        wp_reset_postdata();

                                    else:
                                        ?>
                                        <p><?php _e('Chapters Not Published Yet <i style="color:#ffc900;" class="fa-solid fa-face-frown"></i> '); ?></p>
                                        <?php
                                    endif;
                                    ?>
                                </div>

                            </div>
                            <?php
                            if ( comments_open() || get_comments_number() ) :
                                comments_template();
                            endif;
                            ?>

                            <div>

                            </div>
                        </div>
                    </div>
                </div>






            </main><!-- #main -->
        </div><!-- #primary -->

            
        
    </div>
</div>



<?php get_footer(); ?>